attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
attribute vec4 boneInds;
attribute vec4 boneWeights;

varying vec2 v_texCoord;
varying vec3 v_normal;
varying vec3 v_color;
varying float v_light;

uniform mat4 projMat;
uniform mat4 modelViewMat;

uniform mat4 boneMats[32];

vec3 lightDir = normalize(vec3( 0.3, -0.9, 0.15));

void main()
{

	vec4 pos = vec4(position, 1.0);
	float weightIdent = 1.0 - (boneWeights.x + boneWeights.y + boneWeights.z + boneWeights.w);
	vec4 newPos = pos * weightIdent;
	vec3 newNormal = normal * weightIdent;
	
	int boneIndex = int(boneInds.x);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.x + newPos;
	newNormal = (mat3(boneMats[boneIndex]) * normal) * boneWeights.x + newNormal;
	
	boneIndex = int(boneInds.y);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.y + newPos;
	newNormal = (mat3(boneMats[boneIndex]) * normal) * boneWeights.y + newNormal;
	
	boneIndex = int(boneInds.z);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.z + newPos;
	newNormal = (mat3(boneMats[boneIndex]) * normal) * boneWeights.z + newNormal;
	
	boneIndex = int(boneInds.w);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.w + newPos;
	newNormal = (mat3(boneMats[boneIndex]) * normal) * boneWeights.w + newNormal;
	
	newNormal = normalize( mat3(modelViewMat) * newNormal);
	
	gl_Position = projMat * modelViewMat * newPos;
	v_normal = newNormal;
	v_texCoord = texCoord;
	
	v_light = 1.0 - clamp(dot(lightDir,newNormal),0.3, 1);
	v_light = 1.0 - v_light*v_light;
}