//https://github.com/huamulan/OpenGL-tutorial/blob/master/tutorial13_normal_mapping/NormalMapping.vertexshader

attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
attribute vec3 tangent;
attribute vec3 bitangent;

varying vec2 v_texCoord;
varying vec3 v_pos_w;
varying vec3 v_eye_c;
varying vec3 v_lightDir_c;
varying vec3 v_lightDir_t;
varying vec3 v_eyeDir_t;

uniform mat4 mvp;
uniform mat4 V;
uniform mat4 M;
uniform mat3 MV33;
uniform vec3 LightPos_w;

void main()
{
	gl_Position = mvp * vec4(position, 1);

	v_pos_w = (M * vec4(position, 1)).xyz;

	vec3 pos_c = (V * M * vec4(position, 1)).xyz;
	vec3 v_eyeDir_c = vec3(0,0,0) - pos_c;

	vec3 lightPos_c = (V * vec4(LightPos_w, 1)).xyz;
	v_lightDir_c = lightPos_c - pos_c;

	v_texCoord = texCoord;

	vec3 tangent_c = MV33 * tangent;
	vec3 bitangent_c = MV33 * bitangent;
	vec3 normal_c = MV33 * normal;

	mat3 TBN = mat3(tangent_c, bitangent_c, normal_c);

	v_lightDir_t = TBN * v_lightDir_c;
	v_eyeDir_t = TBN * v_eyeDir_c;
}