attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
attribute vec4 boneInds;
attribute vec4 boneWeights;
attribute vec3 tangent;
attribute vec3 bitangent;

uniform mat4 mvp;
uniform mat4 boneMats[32];
uniform mediump vec3 lightPos;
uniform mediump vec3 eyePos;

varying vec2 v_texCoord;
varying vec3 v_normal;
varying vec3 v_tangent;
varying vec3 v_bitangent;
varying vec3 v_lightDir;
varying vec3 v_eyeDir;

void main()
{
	vec4 pos = vec4(position, 1);
	vec4 nrm = vec4(normal, 0);
	vec4 tng = vec4(tangent, 0);
	vec4 btng = vec4(bitangent, 0);
	int boneIndex = int(boneInds.x);
	vec4 newPos = (boneMats[boneIndex] * pos) * boneWeights.x;
	vec4 newNormal = (boneMats[boneIndex] * nrm) * boneWeights.x;
	vec4 newTangent = (boneMats[boneIndex] * tng) * boneWeights.x;
	vec4 newBitangent = (boneMats[boneIndex] * btng) * boneWeights.x;
	boneIndex = int(boneInds.y);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.y + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.y + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.y + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.y + newBitangent;
	boneIndex = int(boneInds.z);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.z + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.z + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.z + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.z + newBitangent;
	boneIndex = int(boneInds.w);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.w + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.w + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.w + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.w + newBitangent;

	gl_Position = mvp * newPos;

    	v_normal = normalize(newNormal.xyz);
    	v_tangent = normalize(newTangent.xyz);
	v_bitangent = normalize (newBitangent.xyz);
    	v_texCoord = texCoord;

	v_lightDir = normalize(lightPos - newPos.xyz);
	v_eyeDir = normalize(eyePos - newPos.xyz);
}