attribute vec3 position;
attribute vec3 normal;
attribute vec3 tangent;
attribute vec3 bitangent;
attribute vec2 texCoord;

uniform mat4 mvp;
uniform mediump vec3 lightPos;
uniform mediump vec3 eyePos;

varying vec2 v_texCoord;
varying vec3 v_normal;
varying vec3 v_tangent;
varying vec3 v_bitangent;
varying vec3 v_lightDir;
varying vec3 v_eyeDir;

void main(void)
{
    	v_normal = normal;
    	v_tangent = tangent;
	v_bitangent = bitangent;
    	gl_Position = mvp * vec4(position.xyz, 1);
    	v_texCoord = texCoord;

	v_lightDir = normalize(lightPos - position);
	v_eyeDir = normalize(eyePos - position);
}