attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
varying vec2 v_texCoord;
varying vec2 v_texCoord_SSR;
varying vec2 v_texCoord_sphereMap;
varying vec3 v_normal;
varying vec3 v_color;

uniform mat4 projMat;
uniform mat4 modelViewMat;


vec3 eyeDir = normalize(vec3( 0, -0.7, -1));
vec3 lightDir = normalize(vec3( 0.3, -0.9, 0.15));

vec2 getSphereMapCoords(vec3 eye, vec3 normal) 
{
	vec3 reflected = reflect(eye, normal);
	float m = 2.8284271247461903 * sqrt( reflected.z+1.0 );
	return reflected.xy / m + 0.5;
}

vec2 getSSRCoords(vec3 eye, vec3 normal, vec2 scrPos) 
{
	vec3 reflected = (reflect(eye, normal)*0.5);
	float m = 2.8284271247461903 * sqrt( reflected.z+1.0 );
	return normal.xy / (4.0 + dot(eye,normal)) + ((scrPos+1.0)/2.0);
}

void main()
{
	gl_Position = projMat * modelViewMat * vec4(position, 1.0);
	vec3 newNormal = normalize(mat3(modelViewMat) * normal);
	v_texCoord = texCoord;
	v_texCoord_SSR = getSSRCoords( eyeDir, newNormal, gl_Position.xy);
	v_texCoord_sphereMap = getSphereMapCoords( eyeDir, newNormal);
	v_normal = newNormal;
	v_color = 1.0 - clamp(dot(lightDir,newNormal),0.3, 1);
	v_color = 1.0 - v_color*v_color;
}