attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
attribute vec4 boneInds;
attribute vec4 boneWeights;
attribute vec3 tangent;
attribute vec3 bitangent;

uniform mat4 mvp;
//uniform vec3 wLightPos;
uniform vec3 objLightDir;
uniform mat4 boneMats[32];

varying vec2 v_texCoord;
varying vec3 v_lightDir;

void main()
{
	vec4 pos = vec4(position, 1);
	vec4 nrm = vec4(normal, 0);
	vec4 tng = vec4(tangent, 0);
	vec4 btng = vec4(bitangent, 0);

	int boneIndex = int(boneInds.x);
	vec4 newPos = (boneMats[boneIndex] * pos) * boneWeights.x;
	vec4 newNormal = (boneMats[boneIndex] * nrm) * boneWeights.x;
	vec4 newTangent = (boneMats[boneIndex] * tng) * boneWeights.x;
	vec4 newBitangent = (boneMats[boneIndex] * btng) * boneWeights.x;

	/*boneIndex = int(boneInds.y);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.y + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.y + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.y + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.y + newBitangent;
	boneIndex = int(boneInds.z);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.z + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.z + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.z + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.z + newBitangent;
	boneIndex = int(boneInds.w);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.w + newPos;
	newNormal = (boneMats[boneIndex] * nrm) * boneWeights.w + newNormal;
	newTangent = (boneMats[boneIndex] * tng) * boneWeights.w + newTangent;
	newBitangent = (boneMats[boneIndex] * btng) * boneWeights.w + newBitangent;*/

	mat3 tangentSpace = mat3(newTangent.xyz, newBitangent.xyz, newNormal.xyz);

	gl_Position = mvp * newPos;
    	v_texCoord = texCoord;
	//v_lightDir = tangentSpace * normalize(wLightPos - wPosition);
	v_lightDir = tangentSpace * -objLightDir;
}