
float4x4 projMat;
float4x4 modelViewMat;
float4x4 boneMats[32];

float3 lightDir;

struct VS_DEFAULT_OUTPUT 
{
   float4 position: POSITION;
   //float3 normal: NORMAL;
   float2 texture_coord: TEXCOORD0;
   //float3 color_vs : COLOR;
};

VS_DEFAULT_OUTPUT main(float3 position: POSITION, float2 texCoord: TEXCOORD0, float3 normal: NORMAL, float4 boneInds: BLENDINDICES, float4 boneWeights: BLENDWEIGHT)
{
	VS_DEFAULT_OUTPUT Out;
	
	float4 pos = float4(position.x, position.y, position.z, 1.0);
	float4 newPos = pos * (  1.f - (boneWeights.x + boneWeights.y + boneWeights.z + boneWeights.w) );
	//float3 newNormal = float3(0.f, 0.f, 0.f);
	
	for(int i = 0; i < 4; ++i)
    {
		int boneIndex = int(boneInds[i]);
        newPos += boneWeights[i] * mul( boneMats[boneIndex], pos );
        //newNormal += boneWeights[i] * mul(pos, (float3x3)boneMats[boneIndex]);
    }
	
	Out.position = mul( mul(projMat, modelViewMat), float4(newPos.x, newPos.y, newPos.z, 1.f) );
	Out.texture_coord = texCoord;
	
	/*
	float light = 1.0f - dot(normalize(float3( 0.3, -0.9, 0.15)), newNormal);
	light = 1.0f - light*light;
	Out.color_vs = float3(light, light, light);
	//Out.color_vs = 1.0f;
	*/
	
	return Out;
}


