attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
varying vec2 v_texCoord;
varying vec3 v_normal;
varying float v_light;

uniform mat4 projMat;
uniform mat4 modelViewMat;

vec3 lightDir = normalize(vec3( 0.3, -0.9, 0.15));

void main()
{
	gl_Position = projMat * modelViewMat * vec4(position, 1);
	v_texCoord = texCoord;
	v_normal = normalize( mat3(modelViewMat) * normal);
	v_light = 1.0 - clamp(dot(lightDir,v_normal),0.3, 1);
	v_light = 1.0 - v_light*v_light;
}