
float2 texCoordOffsets[4];

struct VS_DEFAULT_OUTPUT
{
    float4 position: POSITION;
    float2 texture_coord: TEXCOORD0;
    float4 color: COLOR0;
};

float4 main(VS_DEFAULT_OUTPUT Out, uniform sampler2D u_texture) : COLOR
{
    	//this will be our RGBA sum
	float4 sum = float4(0,0,0,0);
    
	//apply blurring, using a 9-tap filter with predefined gaussian weights
	sum += tex2D(u_texture, Out.texture_coord - texCoordOffsets[3]) * 0.0162162162;
	sum += tex2D(u_texture, Out.texture_coord - texCoordOffsets[2]) * 0.0540540541;
	sum += tex2D(u_texture, Out.texture_coord - texCoordOffsets[1]) * 0.1216216216;
	sum += tex2D(u_texture, Out.texture_coord - texCoordOffsets[0]) * 0.1945945946;
	
	sum += tex2D(u_texture, Out.texture_coord) * 0.2270270270;
	
	sum += tex2D(u_texture, Out.texture_coord + texCoordOffsets[0]) * 0.1945945946;
	sum += tex2D(u_texture, Out.texture_coord + texCoordOffsets[1]) * 0.1216216216;
	sum += tex2D(u_texture, Out.texture_coord + texCoordOffsets[2]) * 0.0540540541;
	sum += tex2D(u_texture, Out.texture_coord + texCoordOffsets[3]) * 0.0162162162;

	//discard alpha for our simple demo, multiply by vertex color and return
	return Out.color * float4(sum.rgb, 1);
}

/*
float normpdf(in float x, in float sigma)
{
	return 0.39894*exp(-0.5*x*x/(sigma*sigma))/sigma;
}

float4 main(VS_DEFAULT_OUTPUT Out, uniform sampler2D u_texture) : COLOR
{
    //declare stuff
    const int strength = 17;
    int kSize = (strength-1)/2;
    float kernel[strength];
    float3 final_colour = float3(0, 0, 0);
    
    //create the 1-D kernel
    float sigma = 7.0;
    float Z = 0.0;
    for (int j = 0; j <= kSize; ++j)
    {
        kernel[kSize+j] = kernel[kSize-j] = normpdf(float(j), sigma);
    }
    
    //get the normalization factor (as the gaussian has been clamped)
    for (int j = 0; j < strength; ++j)
    {
        Z += kernel[j];
    }
    
    //read out the texels
    for (int i=-kSize; i <= kSize; ++i)
    {
        for (int j=-kSize; j <= kSize; ++j)
        {
            final_colour += kernel[kSize+j]*kernel[kSize+i]*tex2D(u_texture, (Out.texture_coord+(float2(float(i),float(j)) / resolution))).rgb;
        }
    }

    return Out.color * float4(final_colour/(Z*Z), 1);
}
*/