uniform lowp vec4 beginColor;
uniform lowp vec4 endColor;
uniform lowp float direction;

uniform lowp float inverted;
uniform lowp float mirrored;

varying lowp vec2 v_texCoord;
varying lowp vec4 v_color;

void main(void)
{
    lowp float value = mix(v_texCoord.x, v_texCoord.y, direction);
    lowp float mirrored_value = abs(value * 2. - 1.);
    value = mix(value, mirrored_value, mirrored);
    value = abs(inverted - value);

    gl_FragColor = v_color * mix(beginColor, endColor, value);
}