
float maxalpha;
float minalpha;

struct VS_DEFAULT_OUTPUT
{
    float4 position: POSITION;
    float2 texture_coord: TEXCOORD0;
    float4 color: COLOR0;
};

float4 main(VS_DEFAULT_OUTPUT Out, uniform sampler2D u_texture) : COLOR
{
    float4 out_color = tex2D(u_texture, Out.texture_coord) * Out.color;

    if (out_color.w > maxalpha)
        out_color.w = maxalpha;

    if (out_color.w < minalpha)
        out_color.w = 0.0f;

	return out_color;
}