attribute vec3 position;
attribute vec2 texCoord;
attribute vec3 normal;
attribute vec4 boneInds;
attribute vec4 boneWeights;

varying vec2 v_texCoord;
varying vec3 v_normal;

uniform mat4 mvp;
uniform mat4 boneMats[32];

void main()
{
	vec4 pos = vec4(position, 1);
	int boneIndex = int(boneInds.x);
	vec4 newPos = (boneMats[boneIndex] * pos) * boneWeights.x;
	boneIndex = int(boneInds.y);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.y + newPos;
	boneIndex = int(boneInds.z);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.z + newPos;
	boneIndex = int(boneInds.w);
	newPos = (boneMats[boneIndex] * pos) * boneWeights.w + newPos;

	gl_Position = mvp * newPos;
	v_normal = (mvp * vec4(normal.x, normal.y, normal.z, 0)).xyz;
	v_texCoord = texCoord;
}