uniform lowp vec2 scale;

varying lowp vec2 v_texCoord;
varying lowp vec4 v_color;

void main(void)
{
    lowp vec2 texCoord = abs(v_texCoord * 2. - vec2(1., 1.));

    texCoord = vec2(1., 1.) - texCoord;
    texCoord = texCoord * scale;
    texCoord = min(texCoord, 1.);
    texCoord = vec2(1., 1.) - texCoord;
    
    lowp float value = 1. - length(texCoord);
    value = smoothstep(0., .1, value);

    gl_FragColor = v_color * vec4(1., 1., 1., value);
}