uniform lowp float axis;
uniform lowp float scale;

varying lowp vec2 v_texCoord;
varying lowp vec4 v_color;

void main(void)
{
    lowp vec2 texCoord = abs(v_texCoord * 2. - vec2(1., 1.));
    lowp vec2 modifiedTexCoord = texCoord;
    
    modifiedTexCoord = vec2(1., 1.) - modifiedTexCoord;
    modifiedTexCoord = modifiedTexCoord * scale;
    modifiedTexCoord = min(modifiedTexCoord, 1.);
    modifiedTexCoord = vec2(1., 1.) - modifiedTexCoord;

    modifiedTexCoord.x = mix(modifiedTexCoord.x, texCoord.x, axis);
    modifiedTexCoord.y = mix(texCoord.y, modifiedTexCoord.y, axis);

    lowp float value = 1. - length(modifiedTexCoord);
    value = smoothstep(0., .1, value);

    gl_FragColor = v_color * vec4(1., 1., 1., value);
}