uniform lowp vec4 beginColor;
uniform lowp vec4 endColor;
uniform lowp float directionX;
uniform lowp float directionY;

uniform lowp float mirrored;

varying lowp vec2 v_texCoord;
varying lowp vec4 v_color;

void main(void)
{
    lowp float value_x = mix(0., v_texCoord.x, directionX);
    lowp float mirrored_value_x = abs(value_x * 2. - 1.);
    value_x = mix(value_x, mirrored_value_x, mirrored);

    lowp float value_y = mix(0., v_texCoord.y, directionY);
    lowp float mirrored_value_y = abs(value_y * 2. - 1.);
    value_y = mix(value_y, mirrored_value_y, mirrored);

    lowp float value = length(vec2(value_x, value_y));
    gl_FragColor = v_color * mix(beginColor, endColor, value);
}